<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View;

use XCart\Extender\Mapping\ListChild;

/**
 * Amazon checkout widget
 *
 * @ListChild (list="checkout_fastlane.sections.shipping.left", zone="customer", weight="25")
 * @ListChild (list="checkout_fastlane.sections.payment.left", zone="customer", weight="25")
 * @ListChild (list="checkout_fastlane.blocks.address.shipping.before", weight="10")
 * @ListChild (list="checkout_fastlane.blocks.address.billing.before", weight="10")
 * @ListChild (list="checkout.shipping.selected.sub.shipping", weight="120")
 */
class CheckoutShippingButton extends \XLite\View\AView
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        $list = parent::getAllowedTargets();
        $list[] = 'checkout';

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Amazon/PayWithAmazon/checkout_button/shipping.twig';
    }

    /**
     * @return boolean
     */
    protected function isVisible()
    {
        $disabled = \Amazon\PayWithAmazon\Main::hasPaymentDisabledProducts($this->getCart());

        return parent::isVisible() && $this->isCheckoutAvailable() && !$disabled;
    }
}
