<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View;

use XCart\Extender\Mapping\ListChild;

/**
 * @ListChild (list="checkout.review.selected.placeOrder")
 * @ListChild (list="checkout_fastlane.sections.place-order.before")
 */
class CheckoutPlaceButton extends \XLite\View\AView
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        $list = parent::getAllowedTargets();
        $list[] = 'checkout';

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Amazon/PayWithAmazon/checkout_button/order_place.twig';
    }

    /**
     * @return boolean
     */
    protected function isVisible()
    {
        $disabled = \Amazon\PayWithAmazon\Main::hasPaymentDisabledProducts($this->getCart());

        return parent::isVisible() && $this->isCheckoutAvailable() && !$disabled;
    }
}
