<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\Checkout;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class ShippingAddress extends \XLite\View\Checkout\ShippingAddress
{
    /**
     * Check - shipping and billing addrsses are same or not
     *
     * @return boolean
     */
    protected function isAmazonPayment()
    {
        $cart = $this->getCart();
        $method = $cart->getPaymentMethod();

        $transaction = $cart->getFirstOpenPaymentTransaction();
        $sessionId = $transaction ? $transaction->getDataCell('checkoutSessionId') : null;

        return $method
            && $sessionId
            && (\Amazon\PayWithAmazon\Main::getServiceName() === $method->getServiceName());
    }

    /**
     * @param string $fieldName
     * @param array  $fieldData
     *
     * @return array
     */
    public function getFieldAttributes($fieldName, array $fieldData)
    {
        $attrs = parent::getFieldAttributes($fieldName, $fieldData);

        if ($this->isAmazonPayment() && $fieldName !== 'password') {
            $attrs['disabled'] = true;
        }

        return $attrs;
    }
}
