<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\Button\Minicart;

use XCart\Extender\Mapping\ListChild;
use XLite\Model\Cart;

/**
 * @ListChild (list="minicart.horizontal.buttons", weight="1000")
 */
class AmazonCartBtn extends \XLite\View\AView
{
    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Amazon/PayWithAmazon/checkout_button/mini_cart.twig';
    }

    /**
     * @return bool
     */
    public function isPayOnly()
    {
        /** @var Cart $cart */
        $cart = $this->getCart();

        return !$cart->isEmpty() && !$cart->isShippable();
    }
}
