<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Model;

use Doctrine\ORM\Mapping as ORM;
use XCart\Extender\Mapping\Extender;

/**
 * @see \CDev\SocialLogin\Model\Profile
 *
 * @Extender\Mixin
 */
class Profile extends \XLite\Model\Profile
{
    /**
     * Auth provider (amazon)
     *
     * @var string
     *
     * @ORM\Column (type="string", length=128, nullable=true)
     */
    protected $socialLoginProvider;

    /**
     * Auth provider-unique user id (for ex. facebook user id)
     *
     * @var string
     *
     * @ORM\Column (type="string", length=128, nullable=true)
     */
    protected $socialLoginId;

    /**
     * Checks if current profile is a SocialLogin's profile
     *
     * @return boolean
     */
    public function isSocialProfile()
    {
        return (bool) $this->getSocialLoginProvider();
    }

    /**
     * Set socialLoginProvider
     *
     * @param string $socialLoginProvider
     * @return void
     */
    public function setSocialLoginProvider($socialLoginProvider)
    {
        $this->socialLoginProvider = $socialLoginProvider;
    }

    /**
     * Get socialLoginProvider
     *
     * @return string
     */
    public function getSocialLoginProvider()
    {
        return $this->socialLoginProvider;
    }

    /**
     * Set socialLoginId
     *
     * @param string $socialLoginId
     * @return void
     */
    public function setSocialLoginId($socialLoginId)
    {
        $this->socialLoginId = $socialLoginId;
    }

    /**
     * Get socialLoginId
     *
     * @return string
     */
    public function getSocialLoginId()
    {
        return $this->socialLoginId;
    }
}
