<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Model;

use Doctrine\ORM\Mapping as ORM;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Product extends \XLite\Model\Product
{
    /**
     * Amazon payment method is available for product
     *
     * @var boolean
     *
     * @ORM\Column (type="boolean", options={"default" : true})
     */
    protected $amazonPaymentEnabled = true;

    /**
     * @return boolean
     */
    public function getAmazonPaymentEnabled()
    {
        return $this->amazonPaymentEnabled;
    }

    /**
     * @param boolean $amazonPaymentEnabled
     *
     * @return void
     */
    public function setAmazonPaymentEnabled($amazonPaymentEnabled)
    {
        $this->amazonPaymentEnabled = $amazonPaymentEnabled;
    }
}
