<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Model\Payment;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Config;
use XLite\Core\Converter;

/**
 * @Extender\Mixin
 */
class Method extends \XLite\Model\Payment\Method
{
    /**
     * Get message why we can't switch payment method
     *
     * @return string
     */
    public function getNotSwitchableReason()
    {
        $message   = parent::getNotSwitchableReason();
        $processor = $this->getProcessor();

        if (
            $processor
            && \Amazon\PayWithAmazon\Main::getServiceName() === $this->getServiceName()
        ) {
            if (
                $this->getSetting('merchant_id')
                && $this->getSetting('client_id')
                && !Config::getInstance()->Security->customer_security
            ) {
                $message = static::t(
                    'The "Pay with Amazon" feature requires https to be properly set up for your store.',
                    [
                        'url' => Converter::buildURL('https_settings'),
                    ]
                );
            } else {
                $message = static::t('The "Pay With Amazon" feature is not configured and cannot be used.');
            }
        }

        return $message;
    }
}
