<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Model\DTO\Product;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Info extends \XLite\Model\DTO\Product\Info
{
    /**
     * @inheritdoc
     */
    protected function init($object)
    {
        parent::init($object);

        if (\Amazon\PayWithAmazon\Main::getMethod()->isEnabled()) {
            $this->marketing->amazonPaymentEnabled = $object->getAmazonPaymentEnabled();
        }
    }

    /**
     * @inheritdoc
     */
    public function populateTo($object, $rawData = null)
    {
        parent::populateTo($object, $rawData);

        if (\Amazon\PayWithAmazon\Main::getMethod()->isEnabled()) {
            $object->setAmazonPaymentEnabled((bool) $this->marketing->amazonPaymentEnabled);
        }
    }
}
