<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Logic\Import\Processor;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Products extends \XLite\Logic\Import\Processor\Products
{
    // {{{ Columns

    /**
     * Define columns
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['amazonPaymentEnabled'] = [];

        return $columns;
    }

    // }}}

    // {{{ Verification

    /**
     * Get messages
     *
     * @return array
     */
    public static function getMessages()
    {
        return parent::getMessages() + [
            'PRODUCT-AMAZON-PAYMENT-ENABLED-FMT' => 'Wrong "Amazon payment available" format',
        ];
    }

    /**
     * Verify 'amazonPaymentEnabled' value
     *
     * @param mixed $value  Value
     * @param array $column Column info
     *
     * @return void
     */
    protected function verifyAmazonPaymentEnabled($value, array $column)
    {
        if (!$this->verifyValueAsEmpty($value) && !$this->verifyValueAsBoolean($value)) {
            $this->addWarning('PRODUCT-AMAZON-PAYMENT-ENABLED-FMT', ['column' => $column, 'value' => $value]);
        }
    }

    // }}}

    // {{{ Import

    /**
     * Import 'amazonPaymentEnabled' value
     *
     * @param \XLite\Model\Product $model  Product
     * @param string               $value  Value
     * @param array                $column Column info
     *
     * @return void
     */
    protected function importAmazonPaymentEnabledColumn(\XLite\Model\Product $model, $value, array $column)
    {
        $model->setAmazonPaymentEnabled($this->normalizeValueAsBoolean($value));
    }

    // }}}
}
