<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace Amazon\PayWithAmazon\LifetimeHook\Upgrade;

use Amazon\PayWithAmazon\Main;
use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;

final class UpgradeTo552build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $paymentMethod = Database::getRepo('XLite\Model\Payment\Method')->findOneBy([
            'service_name' => Main::getServiceName()
        ]);

        if ($paymentMethod) {
            $em = Database::getEM();
            $clearSettings = ['merchant_id', 'client_id', 'public_key_id', 'private_key_hash'];

            foreach ($clearSettings as $setting) {
                $methodSetting = Database::getRepo('XLite\Model\Payment\MethodSetting')->findOneBy([
                    'payment_method' => $paymentMethod,
                    'name'           => $setting
                ]);

                if ($methodSetting) {
                    $em->remove($methodSetting);
                }
            }

            $em->flush();
        }

        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'Amazon/PayWithAmazon/resources/hooks/upgrade/5.5/2.0/upgrade.yaml');
    }
}
