<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Core;

/**
 * Auth token manager
 */
class TokenManager extends \XLite\Base\SuperClass
{
    /**
     * @param string $strIn
     *
     * @return string
     */
    public function encode($strIn)
    {
        return '@' . bin2hex(
            $this->cryptMethod($strIn)->encrypt($strIn)
        );
    }

    /**
     * @param string $strIn
     *
     * @return string
     */
    public function decode($strIn)
    {
        return $this->cryptMethod($strIn)->decrypt(pack('H*', substr($strIn, 1)));
    }

    /**
     * @param string $strIn
     *
     * @return \phpseclib\Crypt\AES
     */
    protected function cryptMethod($strIn)
    {
        $aes = new \phpseclib\Crypt\AES();

        $key = strval((\Includes\Utils\ConfigParser::getOptions(['installer_details', 'shared_secret_key']) ?? $strIn));
        $aes->setKey($key);
        $aes->setIV($key);
        $aes->setKeyLength(128);

        return $aes;
    }
}
