<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Core;

use XCart\Extender\Mapping\Extender;
use XCart\Messenger\Message\SendMail;
use XLite\Model\Order;
use Amazon\PayWithAmazon\Core\Mail\UpdateAmazonPaymentInfo;

/**
 * @Extender\Mixin
 */
abstract class Mailer extends \XLite\Core\Mailer
{
    /**
     * Send update Amazon payment info notification to customer
     *
     * @param Order $order Order object
     */
    public static function sendUpdateAmazonPaymentInfo(Order $order)
    {
        static::getBus()->dispatch(new SendMail(UpdateAmazonPaymentInfo::class, [$order]));
    }
}
