<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Core;

use Amazon\PayWithAmazon\Main;

/**
 * Google auth provider
 */
class AmazonAuthProvider extends \CDev\SocialLogin\Core\AAuthProvider
{
    /**
     * Unique auth provider name
     */
    public const PROVIDER_NAME = 'amazon';

    /**
     * Url to which user will be redirected
     */
    public const AUTH_REQUEST_URL = '';

    /**
     * Data to gain access to
     */
    public const AUTH_REQUEST_SCOPE = '';

    /**
     * Url to get access token
     */
    public const TOKEN_REQUEST_URL = '';

    /**
     * Url to access user profile information
     */
    public const PROFILE_REQUEST_URL = '';

    /**
     * Get OAuth 2.0 client ID
     *
     * @return string
     */
    protected function getClientId()
    {
        $method = Main::getMethod();

        return $method->getSetting('client_id');
    }

    /**
     * Get OAuth 2.0 client secret
     *
     * @return string
     */
    protected function getClientSecret()
    {
        return true;
    }

    /**
     * Check if auth provider has all options configured
     *
     * @return boolean
     */
    public function isConfigured()
    {
        return parent::isConfigured() && Main::isConfigured();
    }
}
