<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Controller\Customer;

use Amazon\PayWithAmazon\Main;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class ACustomer extends \XLite\Controller\Customer\ACustomer
{
    public function getAddressFields()
    {
        $this->addressFields = parent::getAddressFields();

        if (
            Main::isConfigured()
            && isset($this->addressFields['phone'])
        ) {
            $this->addressFields['phone'][\XLite\View\Model\Address\Address::SCHEMA_REQUIRED] = true;
        }

        return $this->addressFields;
    }

    public function isPayWithAmazonActive()
    {
        $method    = Main::getMethod();
        $processor = Main::getProcessor();

        // disable if no seller id is specified
        if (!$processor->isConfigured($method) || !$method->isEnabled()) {
            return false;
        }

        $cart = $this->getCart();
        if ($cart) {
            if (!$cart->checkCart()) {
                return false;
            }

            return !\Amazon\PayWithAmazon\Main::hasPaymentDisabledProducts($this->getCart());
        }

        return true;
    }
}
