<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\Controller\Admin;

use XLite\InjectLoggerTrait;

class PayWithAmazon extends \XLite\Controller\Admin\AAdmin
{
    use InjectLoggerTrait;

    protected function isPublicZone()
    {
        return \XLite\Core\Request::getInstance()->action === 'register_callback';
    }

    public static function defineFreeFormIdActions()
    {
        return array_merge(
            parent::defineFreeFormIdActions(),
            ['register_callback']
        );
    }

    /**
     * Callback from Amazon signup page
     *
     * @return mixed
     */
    public function doActionRegisterCallback()
    {
        $data = \XLite\Core\Request::getInstance()->getData();
        $token = $this->getMethod()->getSetting('token');
        if (
            (empty($data['token']) || empty($data['payload']))
            || empty($token)
            || ($token && $data['token'] !== $token)
        ) {
            exit;
        }

        $this->getLogger('Amazon-PayWithAmazon')->debug('Amazon connect callback', $data);

        $payload = json_decode($data['payload'], true);
        $publicKeyId = urldecode($payload['publicKeyId']);
        $decryptedKey = null;

        $success = openssl_private_decrypt(
            base64_decode($publicKeyId),
            $decryptedKey,
            $this->getGeneratedPrivateKey()
        );

        if ($success) {
            $payload['public_key_id'] = $decryptedKey;
            $this->updateCredentials($payload);
        }

        $domain = isset($_SERVER['HTTP_ORIGIN']) ? parse_url($_SERVER['HTTP_ORIGIN'], PHP_URL_HOST) : null;
        if ($domain && in_array($domain, \Amazon\PayWithAmazon\Main::getAmazonUrls())) {
            header('Access-Control-Allow-Origin: https://' . $domain);
        }

        header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, X-CSRF-Token');
        header('Vary: Origin');

        $this->displayJSON(['result' => 'success']);
        exit(0);
    }

    /**
     * @param array $data
     *
     * @return void
     */
    protected function updateCredentials(array $data)
    {
        $this->getLogger('Amazon-PayWithAmazon')->debug('Update credentials data', $data);

        $method = $this->getMethod();
        $method->setSetting('merchant_id', $data['merchantId']);
        $method->setSetting('client_id', $data['storeId']);
        $method->setSetting('public_key_id', $data['public_key_id']);
        $generated = $method->getSetting('private_key_generated');
        $method->setSetting('private_key', $generated);
        $method->setSetting('private_key_hash', md5($generated));
        $method->setSetting('token', '');

        $method->update();
    }

    /**
     * @return string
     */
    public function getGeneratedPrivateKey()
    {
        $tokenManager = new \Amazon\PayWithAmazon\Core\TokenManager();

        return $tokenManager->decode($this->getMethod()->getSetting('private_key_generated'));
    }

    /**
     * @return \XLite\Model\Payment\Method
     */
    protected function getMethod()
    {
        return \Amazon\PayWithAmazon\Main::getMethod();
    }
}
