/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Amazon login controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('Amazon/LoginWithAmazon', ['js/jquery', 'Amazon/PayWithAmazon'], function ($, Amazon) {
  $('.social-net-button.social-net-Amazon > div').each(function () {
    socialBtnInit(this.id);
  });

  xcart.microhandlers.add(
    'loginWithAmazonDiv_button',
    '.social-net-button.social-net-Amazon > div',
    function () {
      socialBtnInit(this.id);
    }
  );

  function socialBtnInit(id) {
    if (xliteConfig.target === 'checkout') {
      Amazon.checkoutButton(id);
    } else {
      Amazon.loginButton(id);
    }
  }
});
