/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Js
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('Amazon/PayWithAmazon', ['js/jquery', 'Amazon/Config', 'ready'], function ($, amazonConfig) {
  if (isFastLaneCheckout()) {
    xcart.bind('checkout.main.ready', function () {
      amazonBtn();
    });
  } else {
    return amazonBtn();
  }
});

function amazonBtn() {
  decorate(
    'PopupButtonAddressModify',
    'eachClick',
    function (elem) {
      if (amazonBtn.isAmazonPaymentFlow() && amazonBtn.isTwoStepFlow()) {
        amazonBtn.bindChangeAction(elem);
      } else {
        arguments.callee.previousMethod.apply(this, arguments);
      }
    }
  );

  decorate(
    'PopupButtonAddressBook',
    'eachClick',
    function (elem) {
      if (amazonBtn.isAmazonPaymentFlow() && amazonBtn.isTwoStepFlow()) {
        amazonBtn.bindChangeAction(elem);
      } else {
        arguments.callee.previousMethod.apply(this, arguments);
      }
    }
  );

  decorate(
    'CheckoutAddressView',
    'openAddressBook',
    function (elem) {
      elem.preventDefault();
      if (amazonBtn.isAmazonPaymentFlow() && amazonBtn.isTwoStepFlow()) {
        amazonBtn.bindChangeAction(elem);
      } else {
        arguments.callee.previousMethod.apply(this, arguments);
      }
    }
  )

  decorate(
    'PaymentMethodsView',
    'unshadeDelayed',
    function() {
      arguments.callee.previousMethod.apply(this, arguments);

      let $paymentData = jQuery('.amazon_payment_data');
      if ($paymentData.length) {
        $paymentData.remove();
        $('.amzBinded').remove();
        jQuery('.step-shipping-address').get(0).loadable.load();
      }
    }
  );

  let bindedTypes = [];

  let amazonBtn = {
    button: function (id, type) {
      let el = $('#' + id);

      // element not found or button already created
      if (!el.length || el.get(0).amz_button_placed) {
        return;
      }

      el.get(0).amz_button_placed = true;

      let btnConfig = {
        merchantId: amazonConfig.sid,
        ledgerCurrency: amazonConfig.region,
        sandbox: amazonConfig.mode === 'test',
        // customize the buyer experience
        checkoutLanguage: amazonConfig.locale,
        productType: type === 'Login' ? 'SignIn' : (amazonConfig.isPayOnly ? 'PayOnly' : 'PayAndShip'),
        placement: 'Cart',
        buttonColor: 'Gold'
      };

      if (typeof amazon === 'undefined') {
        return;
      }

      let btnResult = amazon.Pay.renderButton('#' + id, btnConfig);

      if (!bindedTypes.includes(type)) {
        bindedTypes.push(type);

        xcart.bind('createAmazon' + type, function (event, data) {
          let requestType = data ? data['type'] : type;
          amazonBtn.createSession(btnResult, requestType, btnConfig);
        });
      }

      btnResult.onClick(function() {
        if (type === 'Product') {
          amazonBtn.addToCart(el);
          xcart.trigger('createAmazonProduct');
        } else {
          xcart.trigger('createAmazon' + type);
        }
      });

      return btnResult;
    },

    checkoutButton: function (id) {
      let checkoutBtn = this.button(id, 'Checkout');
      if (
        isFastLaneCheckout()
        && amazonBtn.isAmazonPaySelected()
        && !amazonBtn.isTwoStepFlow()
      ) {
        jQuery('button.place-order').closest('form').submit(function (e) {
          e.preventDefault();
          e.stopPropagation();

          amazonBtn.createSession(checkoutBtn, 'ProcessOrder');
          setTimeout(function() {
            xcart.trigger('checkout.common.nonready');
            xcart.trigger('common.unshaded');
            $('button.place-order').removeClass('submitted');
          }, 1000);
        });
      }

      return checkoutBtn;
    },

    cartButton: function (id) {
      return this.button(id, 'Cart');
    },

    productButton: function (id) {
      return this.button(id, 'Product');
    },

    loginButton: function (id) {
      return this.button(id, 'Login');
    },

    createSession: function (btn, type, btnConfig) {
      xcart.post(
        URLHandler.buildURL({
          target: 'cart',
          action: 'createSession'
        }),
        null,
        {
          type: type
        },
        {
          dataType: 'json',
          success: function (data) {
            if (data['error']) {
              xcart.trigger('message', {type: 'error', message: data['error']});
            } else {
              if (type === 'Login') {
                btnConfig['signInConfig'] = data;
                amazon.Pay.initCheckout(btnConfig);
              } else {
                btn.initCheckout({
                  createCheckoutSessionConfig: data
                });
              }
            }
          }
        }
      );
    },

    addToCart: function (el) {
      let form = el.closest('form').get(0);
      if (form) {
        let action = jQuery('input[name="action"]', form).eq(0).val();
        if (action === 'add') {
          form.commonController.backgroundSubmit = true
          $(form).submit();
        }
      }
    },

    isAmazonPaymentFlow: function () {
      if (!amazonConfig.sessionId) {
        return false;
      }

      return this.isAmazonPaySelected();
    },

    isAmazonPaySelected: function () {
      let methodName;
      if (typeof(Checkout) !== 'undefined') {
        let order = Checkout.instance.getState().order;
        methodName = jQuery('#pmethod' + parseInt(order.payment_method)).siblings('.payment-title').text();
      } else {
        methodName = jQuery('.step-payment-methods input[name="methodId"]:checked').siblings('.payment-title').text();
      }

      return methodName === 'Amazon Pay';
    },

    isTwoStepFlow: function () {
      return amazonConfig.sessionId && jQuery('.amazon_payment_data').length
    },

    isOnePageCheckout: function () {
      return jQuery('.checkout_fastlane_container').length === 0
    },

    bindChangeAction: function (elem) {
      if (amazonConfig.sessionId) {
        let dummy = '#payWithAmazon_changeBind';
        if (!jQuery(dummy).hasClass('amzBinded')) {
          amazon.Pay.bindChangeAction(dummy, {
            amazonCheckoutSessionId: amazonConfig.sessionId,
            changeAction: 'changeAddress'
          });
          jQuery(dummy).addClass('amzBinded');
        }

        jQuery(dummy).click();
      }
    }
  }

  if (
    amazonConfig.sessionId
    && xcart.getTarget() === 'checkout'
  ) {
    let paymentChangeBtn = '#payWithAmazon_paymentChange';
    jQuery(paymentChangeBtn).on('click', function () {
      if (!jQuery(paymentChangeBtn).hasClass('amzBinded')) {
        amazon.Pay.bindChangeAction(paymentChangeBtn, {
          amazonCheckoutSessionId: amazonConfig.sessionId,
          changeAction: 'changePayment'
        });
        jQuery(paymentChangeBtn).addClass('amzBinded').click();
      }
    });

    let addressChangeBtn = '#payWithAmazonDiv_address_btn';
    jQuery(addressChangeBtn).on('click', function (e) {
      if (!jQuery(addressChangeBtn).hasClass('amzBinded')) {
        amazon.Pay.bindChangeAction(addressChangeBtn, {
          amazonCheckoutSessionId: amazonConfig.sessionId,
          changeAction: 'changeAddress'
        });
        jQuery(addressChangeBtn).addClass('amzBinded').click();
      }
    });
  }

  xcart.bind('checkout.sections.payment.persist', function () {
    jQuery('.amazon_payment_data').remove();
  });

  xcart.bind('afterPopupPlace', function () {
    let time = (new Date()).getTime();

    amazonBtn.cartButton('payWithAmazonDiv_add2c_popup_btn_' + time);
    amazonBtn.cartButton('payWithAmazonDiv_mini_cart_btn');
  });

  xcart.bind('cart.main.loaded', function () {
    amazonBtn.cartButton('payWithAmazonDiv_cart_btn');
  });

  xcart.bind('minicart.loaded', function () {
    amazonBtn.cartButton('payWithAmazonDiv_mini_cart_btn');
  });

  amazonBtn.checkoutButton('payWithAmazonDiv_co_btn');

  amazonBtn.cartButton('payWithAmazonDiv_cart_btn');
  amazonBtn.cartButton('payWithAmazonDiv_mini_cart_btn');
  amazonBtn.productButton('payWithAmazonDiv_product_btn');

  define(['ProductDetails'], function () {
    xcart.microhandlers.add(
      'ProductDetailButtons',
      '.product-buttons',
      function () {
        amazonBtn.productButton('payWithAmazonDiv_product_btn');
      }
    );
  });

  return amazonBtn;
};

function isFastLaneCheckout() {
  return jQuery('.checkout_fastlane_container').length > 0
};
