/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * FastLane Checkout Pay with Amazon widget
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define(
  'checkout_fastlane/checkout_button/flc_button',
  [
    'vue/vue',
    'checkout_fastlane/sections/section_change_button'
  ],
  function (Vue, ChangeButton) {
    const PwAButton = Vue.extend({
      name: 'pay-with-amazon-button',

      mounted() {
        this.pwaButton('payWithAmazonDiv_co_btn');
      },

      methods: {
        button: function (id, type, color, size, returnUrl) {
          const el = $('#' + id);

          // element not found or button already created
          if (!el.length || el.get(0).amz_button_placed) {
            return;
          }

          el.get(0).amz_button_placed = true;

          size = el.data('size') || size;

          return OffAmazonPayments.Button(
            id,
            amazonConfig.sid,
            {
              type: type,
              color: color,
              size: size,

              authorization: function () {
                if (window.location.protocol === 'https:') {
                  amazon.Login.authorize(
                    {
                      scope: 'profile payments:widget payments:shipping_address',
                      popup: 'true'
                    },
                    returnUrl
                  );
                } else {
                  const loc = window.location;

                  loc.replace('https://' + loc.host + loc.pathname + URLHandler.buildQueryParams({target: 'checkout'}));
                }
              }
            }
          );
        },

        pwaButton: function (id) {
          return this.button(id, 'PwA', 'Gold', 'x-large', URLHandler.buildURL({
            target: 'amazon_login',
            mode: 'payWithAmazon'
          }));
        },
      },
    });

    Vue.registerComponent(ChangeButton, PwAButton);

    return PwAButton;
  }
)
