<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\View\Product;

use XLite\View\AView;
use XLite\View\ItemsList\Product\DemoProductsWarning;
use XCart\Extender\Mapping\ListChild;

/**
 * @ListChild (list="admin.center", zone="admin", weight=100)
 */
class DeleteDemoProducts extends AView
{
    protected function getDefaultTemplate(): string
    {
        return DemoProductsWarning::getDir() . '/popup.twig';
    }

    /**
     * @return string[]
     */
    public static function getAllowedTargets(): array
    {
        return ['delete_demo_products'];
    }
}
