<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\LayoutSettings;

use Includes\Utils\Converter;
use XLite\Core\Skin;

class Settings extends \XLite\View\AView
{
    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'layout_settings/settings/style.less';

        return $list;
    }

    /**
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $list[] = 'layout_settings/controller.js';

        return $list;
    }

    /**
     * @return array
     */
    public function getCurrentSkin()
    {
        return Skin::getInstance()->getCurrentSkinModule();
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'layout_settings/settings/body.twig';
    }

    /**
     * @return string
     */
    protected function getPreviewImageURL()
    {
        return Skin::getInstance()->getCurrentLayoutPreview(\XLite\Core\Layout::LAYOUT_GROUP_HOME);
    }

    /**
     * @return string
     */
    protected function getCurrentSkinName()
    {
        return Skin::getInstance()->getSkinDisplayName();
    }

    /**
     * @return boolean
     */
    protected function showSettingsForm()
    {
        $module = $this->getCurrentSkin();

        return $module && $module['showSettingsForm'];
    }

    /**
     * @return string
     */
    protected function getSettingsForm()
    {
        $module = $this->getCurrentSkin();

        return Converter::buildURL(
            'module',
            '',
            ['moduleId' => $module['id']],
            \XLite::getAdminScript()
        );
    }
}
