<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\View\ItemsList\Product;

use XCart\Extender\Mapping\ListChild;
use XLite\Core\Converter;
use XLite\Core\Database;
use XLite\Core\Translation\Label;
use XLite\Model\Product;
use XLite\View\AView;

/**
 * @ListChild (list="admin.center", zone="admin", weight=10)
 */
class DemoProductsWarning extends AView
{
    public static function getDir(): string
    {
        return 'items_list/product/demo_products_warning';
    }

    protected function getDefaultTemplate(): string
    {
        return static::getDir() . '/body.twig';
    }

    /**
     * @return string[]
     */
    public static function getAllowedTargets(): array
    {
        return array_merge(
            parent::getAllowedTargets(),
            ['product_list']
        );
    }

    /**
     * @return string|Label
     */
    protected function getText()
    {
        return static::t(
            'Your store has X demo products',
            [
                'count' => $this->getDemoProductsCount(),
                'url'   => Converter::buildURL('delete_demo_products')
            ]
        );
    }

    protected function getDemoProductsCount(): int
    {
        return Database::getRepo(Product::class)?->getDemoProductsCount() ?? 0;
    }

    protected function isVisible(): bool
    {
        $result = parent::isVisible();

        if ($result) {
            $result = ($this->getDemoProductsCount() > 0);
        }

        return $result;
    }

    /**
     * @return string[]
     */
    public function getJSFiles(): array
    {
        return array_merge(
            parent::getJSFiles(),
            ['button/js/delete_demo_products.js']
        );
    }

    /**
     * @return array
     */
    public function getCSSFiles(): array
    {
        return array_merge(
            parent::getCSSFiles(),
            ['items_list/product/delete_demo_products.less']
        );
    }
}
