<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\FormField\Input\Text;

/**
 * Modifier
 */
class Modifier extends \XLite\View\FormField\Input\Text
{
    /**
     * Save current form reference and sections list, and initialize the cache
     *
     * @param array $params Widget params OPTIONAL
     *
     * @return void
     */
    public function __construct(array $params = [])
    {
        if (!isset($params[static::PARAM_COMMENT]) || !$params[static::PARAM_COMMENT]) {
            $params[static::PARAM_COMMENT] = 'e.g. +4.05, -10%';
        }

        parent::__construct($params);
    }

    /**
     * Check field validity
     *
     * @return boolean
     */
    protected function checkFieldValidity()
    {
        $result = parent::checkFieldValidity();

        if (
            $result
            && $this->getValue()
            && !preg_match('/^[\-\+]{1}([0-9]+)([\.,]([0-9]+))?([%]{1})?$/Ss', $this->getValue())
        ) {
            $result = false;
            $this->errorMessage = \XLite\Core\Translation::lbl(
                'The value of the X field has an incorrect format',
                [
                    'name' => $this->getLabel(),
                ]
            );
        }

        return $result;
    }

    /**
     * Assemble validation rules
     *
     * @return array
     */
    protected function assembleValidationRules()
    {
        $rules = parent::assembleValidationRules();

        $rules[] = 'custom[modifier]';

        return $rules;
    }
}
