<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\FormField\FileUploader;

/**
 * Image file uploader
 */
class Image extends \XLite\View\FormField\FileUploader\AFileUploader
{
    /**
     * Return 'isImage' flag
     *
     * @return boolean
     */
    protected function isImage()
    {
        return true;
    }

    /**
     * getCommonAttributes
     *
     * @return array
     */
    protected function getCommonAttributes()
    {
        $list = parent::getCommonAttributes();

        $list['data-is_image'] = true;

        return $list;
    }

    protected function getAccept(): string
    {
        $isSvgAllowed = $this->isSvgAllowed();

        return implode(
            ', ',
            array_map(
                static fn (string $ext): string => ".{$ext}",
                array_filter(
                    \XLite\Model\Base\Image::getAllowedExtensions(),
                    static fn(string $ext): bool => ($isSvgAllowed || $ext !== \XLite\Model\Base\Image::SVG_EXTENSION)
                )
            )
        );
    }
}
