<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\View\Form\Product;

use XLite\Core\Converter;
use XLite\View\Form\AForm;

class DeleteDemoProducts extends AForm
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets(): array
    {
        return ['delete_demo_products'];
    }

    protected function getDefaultTarget(): string
    {
        return 'delete_demo_products';
    }

    protected function getDefaultAction(): string
    {
        return 'delete_demo_products';
    }

    protected function setReturnURLParam(array &$params)
    {
        return Converter::buildURL('product_list');
    }
}
