<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\Dashboard\Admin\InfoBlock;

use XCart\Notification\InfoBlockManager;

class InfoBlock extends \XLite\View\AView
{
    private InfoBlockManager $infoBlockManager;

    public function __construct(array $params = [])
    {
        parent::__construct($params);

        $this->infoBlockManager = \XCart\Container::getContainer()->get(InfoBlockManager::class);
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $result   = parent::getCSSFiles();
        $result[] = 'dashboard/info_block/style.less';

        return $result;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'dashboard/info_block/body.twig';
    }

    /**
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible() && \XLite\Core\Auth::getInstance()->isAdmin();
    }

    protected function getNotificationTypes(): string
    {
        $notificationTypes = array_map(
            static fn (string $type): string => sprintf('"%s"', $type),
            $this->infoBlockManager->getClosedNotificationTypes()
        );

        return implode(',', $notificationTypes);
    }
}
