<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\Dashboard\Admin\InfoBlock;

use XCart\Notification\InfoBlockManager;

abstract class ANotification extends \XLite\View\AView
{
    private InfoBlockManager $infoBlockManager;

    public function __construct(array $params = [])
    {
        parent::__construct($params);

        $this->infoBlockManager = \XCart\Container::getContainer()->get(InfoBlockManager::class);
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $result   = parent::getCSSFiles();
        $result[] = 'dashboard/info_block/notification/style.less';

        return $result;
    }

    /**
     * @return array
     */
    public function getJSFiles()
    {
        $result   = parent::getJSFiles();
        $result[] = 'dashboard/info_block/notification/controller.js';

        return $result;
    }

    /**
     * @return string
     */
    abstract protected function getNotificationType();

    /**
     * @return string
     */
    abstract protected function getHeader();

    /**
     * @return int
     */
    protected function getCounter()
    {
        return 0;
    }

    /**
     * @return string
     */
    protected function getHeaderUrl()
    {
        return '';
    }

    /**
     * @return bool
     */
    protected function isExternal()
    {
        return false;
    }

    /**
     * @return string
     */
    protected function getClass()
    {
        return 'infoblock-notification';
    }

    /**
     * @return array
     */
    protected function getTagAttributes()
    {
        return [
            'class'                  => $this->getClass(),
            'data-notification-type' => $this->getNotificationType(),
        ];
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'dashboard/info_block/notification/body.twig';
    }

    /**
     * @return bool
     */
    protected function isVisible()
    {
        return parent::isVisible() && $this->getLastReadTimestamp() < $this->getLastUpdateTimestamp();
    }

    /**
     * Last read timestamp
     *
     * @return integer
     */
    protected function getLastReadTimestamp()
    {
        return $this->infoBlockManager
            ->getLastReadTimestamp(
                $this->getNotificationType()
            );
    }

    /**
     * Return update timestamp
     *
     * @return integer
     */
    protected function getLastUpdateTimestamp()
    {
        return $this->infoBlockManager
            ->getLastUpdateTimestamp(
                $this->getNotificationType()
            );
    }

    /**
     * Set update timestamp
     *
     * @param integer $timestamp Timestamp
     *
     * @return void
     */
    protected function setLastUpdateTimestamp($timestamp): void
    {
        $this->infoBlockManager
            ->setLastUpdateTimestamp(
                $this->getNotificationType(),
                $timestamp
            );
    }

    protected function getNotificationTypes(): string
    {
        $notificationTypes = $this->infoBlockManager->getNotificationTypes();

        $notificationTypes = array_map(
            static fn (string $type): string => sprintf('"%s"', $type),
            $notificationTypes
        );

        return implode(',', $notificationTypes);
    }
}
