<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\Button\Dropdown;

use XLite\View\Button\Features\TooltippedTrait;

/**
 * Order print
 */
class OrderPrint extends \XLite\View\Button\Dropdown\ADropdown
{
    use TooltippedTrait;

    /**
     * Define additional buttons
     *
     * @return array
     */
    protected function defineAdditionalButtons()
    {
        return [
            'invoice' => [
                'class' => 'XLite\View\Button\PrintSelectedInvoices',
                'params'   => [
                    'label'      => 'Print invoice',
                    'style'      => 'action link list-action',
                    'icon-style' => 'fa fa-print',
                ],
                'position' => 100,
            ],
            'packingSlip' => [
                'class' => 'XLite\View\Button\PrintSelectedPackingSlip',
                'params'   => [
                    'label'      => 'Print packing slip',
                    'style'      => 'action link list-action',
                    'icon-style' => 'fa fa-print',
                ],
                'position' => 200,
            ],
        ];
    }

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultTitle()
    {
        return static::t('Print selected');
    }
}
