<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\Repo;

use XLite\Model\SearchFilterTranslation;

/**
 * SearchFilter repository
 */
class SearchFilter extends \XLite\Model\Repo\Base\I18n
{
    use ModelRepoTranslationTrait;

    /**
     * @param string $name Name
     * @param string $filterKey Filter key
     *
     * @return \XLite\Model\SearchFilter
     */
    public function findOneByNameAndKey($name, $filterKey)
    {
        return $this->defineFindOneByNameQuery($name, $filterKey)->getSingleResult();
    }

    /**
     * Define query for findOneByName() method
     *
     * @param string $name Name
     * @param string $filterKey Filter key
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineFindOneByNameQuery($name, $filterKey)
    {
        return $this->createQueryBuilder('sf')
            ->andWhere('translations.name = :name')
            ->andWhere('sf.filterKey = :key')
            ->setParameter('name', $name)
            ->setParameter('key', $filterKey)
            ->setMaxResults(1);
    }

    public function getTranslationDataFromYamlStructure(array $entity, string $lngCode): ?array
    {
        if (
            ($result = $this->getTranslationFromYamlStructure($entity, $lngCode))
            && !empty($result['name'])
        ) {
            return [
                $result['name']
            ];
        }

        return null;
    }

    public function getTranslationDataFromModel(SearchFilterTranslation $translation): ?array
    {
        return [
            $translation->getName()
        ];
    }

    public function generateYamlEntityForTranslationModule(array $data, string $lngCode): ?array
    {
        if (empty($data[0])) {
            return null;
        }

        return [
            'translations' => [
                [
                    'code' => $lngCode,
                    'name' => $data[0]
                ]
            ]
        ];
    }
}
