<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\Repo\Role;

use XLite\Model\Repo\ModelRepoTranslationTrait;
use XLite\Model\Role\PermissionTranslation;

/**
 * Permission repository
 */
class Permission extends \XLite\Model\Repo\Base\I18n
{
    use ModelRepoTranslationTrait;

    /**
     * Alternative record identifiers
     *
     * @var array
     */
    protected $alternativeIdentifier = [
        ['code'],
    ];

    public function getTranslationDataFromYamlStructure(array $entity, string $lngCode): ?array
    {
        if (
            !empty($entity['code'])
            && !empty($entity['section'])
            && ($result = $this->getTranslationFromYamlStructure($entity, $lngCode))
        ) {
            return [
                $entity['code'],
                $entity['section'],
                $result['name'] ?? '',
                $result['description'] ?? ''
            ];
        }

        return null;
    }

    public function getTranslationDataFromModel(PermissionTranslation $translation): ?array
    {
        /** @var \XLite\Model\Role\Permission $permission */
        $permission = $translation->getOwner();

        return [
            $permission->getCode(),
            $permission->getSection(),
            $translation->getName(),
            $translation->getDescription()
        ];
    }

    public function getTranslationSearchCellsCount(): int
    {
        return 2;
    }

    public function generateYamlEntityForTranslationModule(array $data, string $lngCode): ?array
    {
        if (empty($data[0]) || empty($data[1])) {
            return null;
        }

        return [
            'code'         => $data[0],
            'section'      => $data[1],
            'translations' => [
                array_filter([
                    'code'        => $lngCode,
                    'name'        => $data[2] ?? '',
                    'description' => $data[3] ?? '',
                ])
            ]
        ];
    }
}
