<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\Repo;

use DateTimeImmutable;
use DateTimeInterface;
use Gesdinet\JWTRefreshTokenBundle\Doctrine\RefreshTokenRepositoryInterface;

class RefreshToken extends ARepo implements RefreshTokenRepositoryInterface
{
    /**
     * @param DateTimeInterface|null $datetime
     *
     * @return \Gesdinet\JWTRefreshTokenBundle\Entity\RefreshToken[]
     */
    public function findInvalid($datetime = null)
    {
        $datetime = $datetime ?? new DateTimeImmutable();

        return $this->createQueryBuilder('entity')
            ->where('entity.valid < :datetime')
            ->setParameter(':datetime', $datetime)
            ->getResult();
    }
}
