<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\Model\Repo;

use XLite\Model\Base\Translation;

trait ModelRepoTranslationTrait
{
    public function getTranslationModelFQN(): string
    {
        return $this->getEntityName() . 'Translation';
    }

    public function getTranslationSearchCellsCount(): int
    {
        return 1;
    }

    protected function getTranslationFromYamlStructure(array $entity, string $lngCode): ?array
    {
        if (!isset($entity['directives']) && !empty($entity['translations'])) {
            foreach ($entity['translations'] as $translation) {
                if (($translation['code'] ?? '') === $lngCode) {
                    return $entity;
                }
            }
        }

        return null;
    }

    public function getTranslationDataFromYamlStructure(array $entity, string $lngCode): ?array
    {
        return $this->getTranslationFromYamlStructure($entity, $lngCode);
    }

    public function getTranslationDataFromModel(Translation $translation): ?array
    {
        return null;
    }

    public function generateYamlEntityForTranslationModule(array $data, string $lngCode): ?array
    {
        return null;
    }

    public function getYamlDirectives(): array
    {
        $directives = [
            'allowedModel' => $this->getTranslationModelFQN()
        ];

        return [
            'directives' => $directives
        ];
    }
}
