<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model;

/**
 * Remove data cell
 */
class RemoveDataCell extends \XLite\Model\Base\Dump
{
    /**
     * Name
     *
     * @var string
     */
    protected $name;

    /**
     * Data type (is used in the message "there are no [data_type] in the store")
     */
    protected string $dataType = '';

    protected string $tooltip = '';

    public function getDataType(): string
    {
        return $this->dataType ?: lcfirst($this->name);
    }
}
