<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\QueryBuilder;

use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\CommonQueryBuilder;

/**
 * Abstract query builder
 */
abstract class AQueryBuilder extends CommonQueryBuilder
{
    /**
     * Data storage
     *
     * @var   array
     */
    protected $dataStorage = [];

    // {{{ Result helpers

    /**
     * Get result as object array.
     *
     * @return array
     */
    public function getObjectResult()
    {
        $result = [];

        foreach ($this->getResult() as $idx => $item) {
            $result[$idx] = is_object($item) ? $item : $item[0];
        }

        return $result;
    }

    /**
     * Execute query
     *
     * @return mixed
     */
    public function execute()
    {
        return $this->getQuery()->execute();
    }

    /**
     * Get only entities
     *
     * @return array
     */
    public function getOnlyEntities()
    {
        $result = [];

        foreach ($this->getResult() as $entity) {
            if (is_array($entity)) {
                $entity = $entity[0];
            }

            $result[] = $entity;
        }

        return $result;
    }

    // }}}

    // {{{ Query builder helpers

    /**
     * Bind macro date
     *
     * @param string  $field Field name
     * @param integer $start Start date OPTIONAL
     * @param integer $end   End date OPTIONAL
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    public function bindMacroDate($field, $start = null, $end = null)
    {
        $suffix = str_replace('.', '_', $field);

        if (is_int($start)) {
            $this->andWhere($field . ' >= :startDate' . $suffix)
                ->setParameter('startDate' . $suffix, $start);
        }

        if (is_int($end)) {
            $this->andWhere($field . ' <= :endDate' . $suffix)
                ->setParameter('endDate' . $suffix, $end);
        }

        return $this;
    }

    // }}}

    // {{{ Data storage

    /**
     * Get data cell
     *
     * @param string $name Cell name
     *
     * @return mixed
     */
    public function getDataCell($name)
    {
        return $this->dataStorage[$name] ?? null;
    }

    /**
     * Set data cell
     *
     * @param string $name  Cell name
     * @param mixed  $value Value
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    public function setDataStorage($name, $value)
    {
        $this->dataStorage[$name] = $value;

        return $this;
    }

    // }}}
}
