<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\Payment;

use Doctrine\ORM\Mapping as ORM;

/**
 * Payment method multilingual data
 *
 * @ORM\Entity
 * @ORM\Table (name="payment_method_translations",
 *      indexes={
 *          @ORM\Index (name="ci", columns={"code","id"}),
 *          @ORM\Index (name="id", columns={"id"})
 *      }
 * )
 */
class MethodTranslation extends \XLite\Model\Base\Translation
{
    /**
     * Name
     *
     * @var string
     *
     * @ORM\Column (type="string", length=255)
     */
    protected $name;

    /**
     * Title (Name of payment method which is displayed for customer on checkout)
     *
     * @var string
     *
     * @ORM\Column (type="string", length=255)
     */
    protected $title = '';

    /**
     * Description
     *
     * @var string
     *
     * @ORM\Column (type="text")
     */
    protected $description = '';

    /**
     * Admin description
     *
     * @var string
     *
     * @ORM\Column (type="text")
     */
    protected $adminDescription = '';

    /**
     * Alternative admin description
     *
     * @var string
     *
     * @ORM\Column (type="text")
     */
    protected $altAdminDescription = '';

    /**
     * Instruction
     *
     * @var string
     *
     * @ORM\Column (type="text")
     */
    protected $instruction = '';

    /**
     * @var \XLite\Model\Payment\Method
     *
     * @ORM\ManyToOne (targetEntity="XLite\Model\Payment\Method", inversedBy="translations")
     * @ORM\JoinColumn (name="id", referencedColumnName="method_id", onDelete="CASCADE")
     */
    protected $owner;

    /**
     * Title getter
     * If no title is given then the "name" field must be used
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title ?: $this->getName();
    }

    /**
     * Admin description getter
     * If no admin description is given then the "description" field must be used
     *
     * @return string
     */
    public function getAdminDescription()
    {
        return $this->adminDescription ?: $this->getDescription();
    }

    /**
     * Set name
     *
     * @param string $name
     * @return MethodTranslation
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return MethodTranslation
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return MethodTranslation
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set adminDescription
     *
     * @param string $adminDescription
     * @return MethodTranslation
     */
    public function setAdminDescription($adminDescription)
    {
        $this->adminDescription = $adminDescription;
        return $this;
    }

    /**
     * Set altAdminDescription
     *
     * @param string $altAdminDescription
     * @return MethodTranslation
     */
    public function setAltAdminDescription($altAdminDescription)
    {
        $this->altAdminDescription = $altAdminDescription;
        return $this;
    }

    /**
     * Get altAdminDescription
     *
     * @return string
     */
    public function getAltAdminDescription()
    {
        return $this->altAdminDescription;
    }

    /**
     * Set instruction
     *
     * @param string $instruction
     * @return MethodTranslation
     */
    public function setInstruction($instruction)
    {
        $this->instruction = $instruction;
        return $this;
    }

    /**
     * Get instruction
     *
     * @return string
     */
    public function getInstruction()
    {
        return $this->instruction;
    }

    /**
     * Get label_id
     *
     * @return integer
     */
    public function getLabelId()
    {
        return $this->label_id;
    }

    /**
     * Set code
     *
     * @param string $code
     * @return MethodTranslation
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
}
