<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model;

/**
 * ____description____
 * TODO[SINGLETON] - must extends the Base\Singleton
 * NOTE - check the "factory.<name>" tags in templates
 */
class Factory extends \XLite\Base
{
    /**
     * Create object instance and pass arguments to it contructor (if needed)
     *
     * @param string $class Class name
     * @param array  $args  Constructor arguments OPTIONAL
     *
     * @return \XLite\Base
     */
    public static function create($class, array $args = [])
    {
        $handler = new \ReflectionClass($class);

        return static::isSingleton($handler) ? static::getSingleton($class) : static::createObject($handler, $args);
    }


    /**
     * Check if class is a singleton
     * FIXME - must be revised or removed
     *
     * @param \ReflectionClass $handler Class descriptor
     *
     * @return boolean
     */
    protected static function isSingleton(\ReflectionClass $handler)
    {
        return $handler->getConstructor()->isProtected();
    }

    /**
     * Return a singleton refernce
     *
     * @param string $class Class name
     *
     * @return \XLite\Base
     */
    protected static function getSingleton($class)
    {
        return call_user_func([$class, 'getInstance']);
    }

    /**
     * Create new object
     *
     * @param \ReflectionClass $handler Class descriptor
     * @param array            $args    Constructor params OPTIONAL
     *
     * @return \XLite\Base
     */
    protected static function createObject(\ReflectionClass $handler, array $args = [])
    {
        return $handler->hasMethod('__construct') ? $handler->newInstanceArgs($args) : $handler->newInstance();
    }


    /**
     * Create object instance
     *
     * @param string $name Class name
     *
     * @return \XLite\Base
     */
    public function __get($name)
    {
        return static::create($name);
    }
}
