<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\RemoveData\Step;

use Iterator;
use XLite\Core\Database;
use XLite\Model\Product;

class DemoProducts extends AStep
{
    protected function getRepository(): \XLite\Model\Repo\Product
    {
        return Database::getRepo(Product::class);
    }

    /**
     * @return integer
     */
    public function count(): int
    {
        if (!isset($this->countCache)) {
            $options = $this->generator->getOptions();
            $index = 'count' . get_class($this);

            if (!isset($options[$index])) {
                $options[$index] = $this->getRepository()->getDemoProductsCount();
            }

            $this->countCache = $options[$index];
        }

        return $this->countCache;
    }

    /**
     * Get items iterator
     *
     * @param boolean $reset Reset iterator OPTIONAL
     *
     * @return Iterator
     */
    protected function getItems($reset = false)
    {
        if (!isset($this->items) || $reset) {
            $this->items = $this->getRepository()->getRemoveDemoDataIterator($this->position);
            $this->items->rewind();
        }

        return $this->items;
    }
}
