<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\MembershipsQuickData\Step;

/**
 * Abstract step
 */
abstract class AStep extends \XLite\Logic\ARepoStep
{
    /**
     * \Countable::count
     *
     * @return integer
     */
    public function count(): int
    {
        if (!isset($this->countCache)) {
            $this->countCache = $this->getRepository()->countForQuickData();
        }

        return $this->countCache;
    }

    // {{{ Data

    /**
     * Get items iterator
     *
     * @param boolean $reset Reset iterator OPTIONAL
     *
     * @return \Doctrine\ORM\Internal\Hydration\IterableResult
     */
    protected function getItems($reset = false)
    {
        if (!isset($this->items) || $reset) {
            $this->items = $this->getRepository()->getMembershipsQuickDataIterator($this->position);
            $this->items->rewind();
        }

        return $this->items;
    }

    // }}}
}
