<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console\Step;

use Symfony\Component\Console\Style\SymfonyStyle;
use XLite\Logic\Import\Console\Step\Base\DataStep;
use XLite\Logic\Import\Processor\AProcessor;

class Verification extends DataStep
{
    public function process(): void
    {
        /** @var SymfonyStyle $io */
        $io = $this->importer->getIo();
        $progressBar = $io->createProgressBar();
        $progressBar->setFormat(static::PROGRESS_BAR_FORMAT);
        $progressBar->start();

        $processor = $this->getProcessor();
        $reader = $this->getReader($this->getFile(), $processor);
        $reader->init();

        while ($data = $reader->getData()) {
            $processor->process($data, AProcessor::MODE_VERIFICATION);
            $progressBar->advance();
        }

        $progressBar->finish();
    }

    public function getFinalNote(): string
    {
        return static::t('Verified');
    }

    public function getNote(): string
    {
        return static::t('Verifying data before importing...');
    }
}
