<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console\Step;

use Symfony\Component\Console\Style\SymfonyStyle;
use XLite\Core\Database;
use XLite\Core\QuickData as QuickDataCore;

class QuickData extends AStep
{
    public function process(): void
    {
        $em = Database::getEM();

        /** @var SymfonyStyle $io */
        $io = $this->importer->getIo();
        $quickData = QuickDataCore::getInstance();
        $batchSize = QuickDataCore::CHUNK_LENGTH;

        $initialCount = $quickData->countUnprocessed();
        $progressBar = $io->createProgressBar($initialCount);
        $progressBar->setFormat(static::PROGRESS_BAR_FORMAT);
        $progressBar->start();

        $q = $em->createQuery('SELECT p from XLite\Model\Product p WHERE p.needProcess = 1');
        $result = $q->toIterable();

        $i = 0;
        foreach ($result as $product) {
            $quickData->updateProductDataInternal($product);
            $i++;
            if ($i % $batchSize === 0) {
                $progressBar->advance($batchSize);
                $em->flush();
                $em->clear();
            }
        }

        $progressBar->advance($initialCount % $batchSize);
        $em->flush();
        $em->clear();
    }

    public function isAllowed(): bool
    {
        return parent::isAllowed() && QuickDataCore::getInstance()->countUnprocessed();
    }

    public function getFinalNote(): string
    {
        return static::t('Products processed');
    }

    public function getNote(): string
    {
        return static::t('Processing products...');
    }
}
