<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console\Step;

use Symfony\Component\Filesystem\Filesystem;

class ClearCache extends AStep
{
    public function process(): void
    {
        (new Filesystem())->remove(LC_DIR_VAR . 'import-tmp/');
    }

    public function getFinalNote(): string
    {
        return static::t('Cache is cleaned');
    }

    public function getNote(): string
    {
        return static::t('Cleaning cache...');
    }
}
