<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console\Step\Base;

use XLite\Logic\Import\Console\Step\AStep;
use XLite\Logic\Import\Processor\AProcessor;

abstract class DataStep extends AStep
{
    protected function getProcessor(): AProcessor
    {
        $processorClass = $this->importer->getProcessorClass();

        return new $processorClass($this->importer);
    }

    public function isValid(): bool
    {
        return $this->getProcessor() && $this->getProcessor()->isValid();
    }
}
