<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console\Processor;

use XLite\Logic\Import\Processor\AttributeValues\AAttributeValue;
use XLite\Logic\Import\Processor\AttributeValues\AttributeValueCheckbox;
use XLite\Logic\Import\Processor\AttributeValues\AttributeValueHidden;
use XLite\Logic\Import\Processor\AttributeValues\AttributeValueSelect;
use XLite\Logic\Import\Processor\AttributeValues\AttributeValueText;
use XLite\Logic\Import\Console\Step\AStep;

final class ProductAttributes extends AAttributeValue
{
    private const TYPE_CHECKBOX = 'C';
    private const TYPE_HIDDEN = 'H';
    private const TYPE_SELECT = 'S';
    private const TYPE_TEXT = 'T';

    public function assembleColumnsData(array $rows, ?bool $normalize = null)
    {
        $typeRaw = $this->getColumn('type');
        $typeProcessed = $this->processColumn('type', $typeRaw);
        $this->attributeType = $this->assembleColumnData($typeProcessed, $rows);

        return $this->attributeType ? parent::assembleColumnsData($rows) : [];
    }

    public function process(array $rows, string $mode): bool
    {
        switch ($rows['type'] ?? '') {
            case self::TYPE_CHECKBOX:
                $subProcessor = $this->getCheckboxProcessor();
                break;
            case self::TYPE_HIDDEN:
                $subProcessor = $this->getHiddenProcessor();
                break;
            case self::TYPE_SELECT:
                $subProcessor = $this->getSelectProcessor();
                break;
            case self::TYPE_TEXT:
                $subProcessor = $this->getTextProcessor();
                break;
            default:
                return false;
        }

        $metaData = $this->importer->getOptions()->columnsMetaData[$this::class];
        $this->importer->getOptions()->columnsMetaData[$subProcessor::class] = $metaData;

        return $subProcessor->process($rows, $mode);
    }

    private function getCheckboxProcessor(): AttributeValueCheckbox
    {
        return new AttributeValueCheckbox($this->importer);
    }

    private function getHiddenProcessor(): AttributeValueHidden
    {
        return new AttributeValueHidden($this->importer);
    }

    private function getSelectProcessor(): AttributeValueSelect
    {
        return new AttributeValueSelect($this->importer);
    }

    private function getTextProcessor(): AttributeValueText
    {
        return new AttributeValueText($this->importer);
    }

    protected function getRepository()
    {
    }

    public function allowTwoIterationCacheProcess(AStep $stap): bool
    {
        return false;
    }
}
