<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Logic\Import\Console;

use JsonException;
use SplFileObject;
use XLite\Logic\Import\Processor\AProcessor;

class JSONLImportFileReader implements ConsoleImportFileReaderInterface
{
    private SplFileObject $file;

    private AProcessor $processor;

    public function __construct(string $path, AProcessor $processor)
    {
        $this->processor = $processor;
        $this->file = new SplFileObject($path, 'r');
        $this->file->rewind();
    }

    public function init(): void
    {
        $this->processor->initialize();
    }

    /**
     * @throws JsonException
     */
    public function getData(): ?array
    {
        $row = $this->getRow();
        $data = [];
        if ($row) {
            $data = json_decode($row, true, 512, JSON_THROW_ON_ERROR);
        }

        return $data ?: null;
    }

    /**
     * @throws JsonException
     */
    public function getBatch(int $size = 100): array
    {
        $batch = [];
        $i = 0;
        while ($i < $size) {
            $data = $this->getData();
            if (!$data) {
                break;
            }
            $batch[] = $data;
            $i++;
        }

        return $batch;
    }

    public function getRow(): ?string
    {
        if (!$this->file->valid()) {
            return null;
        }

        $row = $this->file->getCurrentLine();
        $row = trim($row);

        if ($row === '') {
            return $this->getRow();
        }

        return $row ?: null;
    }
}
