<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite;

use Exception;
use JetBrains\PhpStorm\Deprecated;
use Psr\Log\LoggerInterface;

trait InjectLoggerTrait
{
    /**
     * @param string   $name
     * @param int|null $level @deprecated since CCDev-Core 5.5.1, This parameter is unused and deprecated
     *
     * @return LoggerInterface
     */
    protected static function getStaticLogger(string $name = 'xlite', #[Deprecated] ?int $level = null): LoggerInterface
    {
        if (isset($level)) {
            trigger_deprecation('CDev-Core', '5.5.1', '"%s" parameter of "%s" is unused and deprecated', 'level', __METHOD__);
        }

        return Logger::getLogger($name, $level);
    }

    /**
     * @param string   $name
     * @param int|null $level @deprecated since CCDev-Core 5.5.1, This parameter is unused and deprecated
     *
     * @return LoggerInterface
     */
    protected function getLogger(string $name = 'xlite', #[Deprecated] ?int $level = null): LoggerInterface
    {
        if (isset($level)) {
            trigger_deprecation('CDev-Core', '5.5.1', '"%s" parameter of "%s" is unused and deprecated', 'level', __METHOD__);
        }

        return static::getStaticLogger($name);
    }

    /**
     * @param int    $level
     * @param string $message
     * @param array  $context
     */
    protected function logPostponed(int $level = 0, string $message = '', $context = []): void
    {
        Logger::getInstance()->logPostponed($message, $level, null, $context);
    }

    /**
     * @param Exception $exception
     */
    protected function logException(Exception $exception): void
    {
        Logger::getInstance()->registerException($exception);
    }
}
