<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\Core;

use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Crutch\SingletonTrait;
use XLite\Model\TmpVar;
use XLite\Model\Repo\TmpVar as TmpVarRepository;

/**
 * DB-based temporary variables
 */
class TmpVars
{
    use SingletonTrait;

    protected static string $singletonServiceId = TmpVars::class;

    /**
     * @param TmpVarRepository $repository
     */
    public function __construct(
        private WriteRepositoryInterface $repository
    ) {
    }

    public function __get(string $name): mixed
    {
        return $this->repository->getVar($name);
    }

    public function __set(string $name, mixed $value): void
    {
        if ($value === null) {
            $this->repository->removeVar($name);
        } else {
            $this->repository->setVar($name, $value);
        }
    }

    public function __isset(string $name): bool
    {
        return !is_null($this->getVar($name));
    }

    protected function getVar(string $name): ?TmpVar
    {
        return $this->repository->findOneBy(['name' => $name]);
    }
}
