<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Core\RemoteResource;

use Exception;

interface IURL
{
    /**
     * @param string $url
     *
     * @return boolean
     */
    public static function isMatch($url);

    /**
     * @param string $url
     */
    public function __construct($url);

    /**
     * @return boolean
     */
    public function isAvailable();

    /**
     * @return string
     */
    public function getURL();

    /**
     * @return array
     * @throws Exception
     */
    public function getHeaders();

    /**
     * @return string
     */
    public function getName();
}
