<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Core\PhoneNumber;

use libphonenumber\PhoneNumberUtil as LibPhoneNumberUtil;

/**
 * PhoneNumberUtil based on libphonenumber library
 * https://github.com/giggsey/libphonenumber-for-php
 */
class PhoneNumberUtil extends \XLite\Base\Singleton
{
    /**
     * PhoneNumberUtil instance
     *
     * @var LibPhoneNumberUtil
     */
    protected static $utilInstance = null;

    public static function getInstance(): PhoneNumberUtil
    {
        $result = parent::getInstance();

        if (is_null(static::$utilInstance)) {
            static::$utilInstance = LibPhoneNumberUtil::getInstance();
        }

        return $result;
    }

    /**
     * Returns country calling code (numeric format)
     *
     * @param string $phone
     *
     * @return string
     */
    public function getCountryCode(string $phone)
    {
        $result = '';

        if ($phone) {
            $phoneNumber = static::$utilInstance->parse($phone);
            $result = $phoneNumber->getCountryCode();
        }

        return $result;
    }

    public function getNationalNumber(string $phone)
    {
        $result = '';

        if ($phone) {
            $phoneNumber = static::$utilInstance->parse($phone);
            $result = $phoneNumber->getNationalNumber();
        }

        return $result;
    }

    /**
     * Returns the country code where a phone number is from.
     * In ISO-format (two-letter code: alpha-2)
     *
     * @param string $phone
     *
     * @return string
     */
    public function getISOCountryCode(string $phone)
    {
        $result = '';

        if ($phone) {
            $phoneNumber = static::$utilInstance->parse($phone);
            $result = static::$utilInstance->getRegionCodeForNumber($phoneNumber);
        }

        return $result;
    }
}
