<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Core;

use Detection\MobileDetect as BaseMobileDetect;

/**
 * Events subsystem
 */
class MobileDetect extends \XLite\Base\Singleton
{
    /**
     * Device detection
     */
    public BaseMobileDetect $detect;

    /**
     * Method to access a singleton
     */
    public static function getInstance()
    {
        return parent::getInstance()->detect;
    }

    /**
     * Check if the mobile device is a phone
     */
    public static function isMobilePhone(): bool
    {
        /** @var BaseMobileDetect $instance */
        $instance = static::getInstance();

        return $instance->isMobile() && !$instance->isTablet();
    }

    protected function __construct()
    {
        $this->detect = new BaseMobileDetect();
    }
}
