<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Core\Mail\Common;

use XLite\Core\Mailer;
use XLite\Model\Profile;

class ResetPassword extends \XLite\Core\Mail\AMail
{
    public static function getZone()
    {
        return \XLite::ZONE_CUSTOMER;
    }

    public static function getDir()
    {
        return 'reset_password';
    }

    protected static function defineVariables()
    {
        return [
                'password' => 'xxxxxxxxxx',
            ] + parent::defineVariables();
    }

    public function __construct(Profile $profile, string $password)
    {
        parent::__construct();

        $this->setFrom(Mailer::getSiteAdministratorMail());
        $this->setReplyTo(Mailer::getSiteAdministratorMails());
        $this->tryToSetLanguageCode($profile->getLanguage());

        $this->setTo([
            'email' => $profile->getLogin(),
            'name'  => $profile->getName(false),
        ]);

        $this->appendData([
            'password'       => $password,
            'profile'        => $profile,
            'recipient_name' => $profile->getName(),
        ]);

        $this->populateVariables([
            'first_name' => $profile->getName(true, true),
        ]);
    }
}
