<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Core;

class IteratorsIterator implements \Iterator
{
    /**
     * @var \Iterator[]
     */
    private $iterators;
    /**
     * @var \Iterator|null
     */
    private $active;

    public function __construct(array $iterators)
    {
        $this->iterators = array_values($iterators);
        $this->rewind();
    }

    public function current(): mixed
    {
        return $this->active
            ? $this->active->current()
            : null;
    }

    public function next(): void
    {
        if ($this->active) {
            $this->active->next();

            if (!$this->active->valid()) {
                $this->pushQueue();
            }
        }
    }

    public function key(): mixed
    {
        return $this->active
            ? $this->active->key()
            : null;
    }

    public function valid(): bool
    {
        if ($this->active) {
            if (!$this->active->valid()) {
                $this->pushQueue();
                return $this->valid();
            }

            return true;
        }

        return false;
    }

    public function rewind(): void
    {
        $this->active = $this->iterators[0] ?? null;

        array_map(static function ($i) {
            $i->rewind();
        }, $this->iterators);
    }

    private function pushQueue(): void
    {
        if ($this->active) {
            $this->active = $this->iterators[array_search($this->active, $this->iterators, true) + 1] ?? null;
        }
    }
}
